"""
practical1_carbon.py
"""
import numpy as np

# c14 as a function of time and initial value
def c14(initval,t):
    lam = 1.21e-4
    c = initval*np.exp(-lam*t)
    return c

# age as a function of ratio of current and initial values
def age(r_t,r_init):
    lam = 1.21e-4
    t = -np.log(r_t/r_init)/lam
    return t

# calculate ages from dataset of ratios - take initial ratio = 1
r = [1.4e-12, 1.1e-12,0.8e-12,0.4e-12,0.2e-12,0.1e-12,0.01e-12]
for ratio in r:
    print('age={0:10.3f} years'.format(age(ratio,1)))

# plot out C14 as a function of t
initval = 500
t = np.linspace(0,30000,3001)

import matplotlib.pyplot as plt
plot1 = plt.figure(1)
plt.plot(t,c14(initval,t),'r') 
plt.xlim([0,30000])
plt.ylim([0,500])
plt.xlabel('time (years)')
plt.title(r'Amount of $C_{14}$ as a function of time')

# end practical1_carbon.py