"""
Solves an initial value problem modelling a simple chemical reaction
 A + B --> C, with rate constant k

"""
import numpy as np
from scipy.integrate import odeint

# define the rhs function, f
def f(u,t,rate_constant):
    x,y,z=u
    return [-rate_constant*u[0]*u[1],-rate_constant*u[0]*u[1],rate_constant*u[0]*u[1]]

rate_constant = 1.0
tend = 10.0
A_0 = 2.0
B_0 = 1.0
C_0 = 0.0

u0 = [A_0,B_0,C_0]
t = np.linspace(0,tend,1000)
u = odeint(f,u0,t,args=(rate_constant,))

A = u[:,0]
B = u[:,1]
C = u[:,2]

# plot out results
import matplotlib.pyplot as plt
plt.plot(t,A,'r')
plt.plot(t,B,'b')
plt.plot(t,C,'g')
plt.xlim([0,10])
plt.ylim([0,2])
plt.xlabel('Time')
plt.ylabel('Concentration')
plt.legend(['A','B','C'])
plt.savefig('simple_reaction.jpg')