# program to solve q4 from 22-23 
import numpy as np
import matplotlib.pyplot as plt

print('Reading all metamodel data\n')
builddata = open('build.txt','r').readlines()
oxalldata = []
Poxalldata = []
for line in builddata:
    oxalldata.append(float(line.split()[0]))
    Poxalldata.append(float(line.split()[1]))

print ('data read finished')

# build 1st order fit to build data
p11 = np.polyfit(oxalldata,Poxalldata,1)
p1 = np.poly1d(p11)
N = 101
x = np.linspace(0,2,N)
Pox1alldata = p1(oxalldata)
p1vals = p1(x)

# plot out functions
plot1 = plt.figure(1)
plt.ylabel('Pox')
plt.xlabel('x')
plt.title('Comparison between experimental data points and 1st order fit')
plt.plot(oxalldata,Poxalldata,marker='o',c='r')
plt.plot(x,p1vals)
plt.xlim([0,2])
plt.ylim([1,4])
plt.legend(['experimental data','1st order fit'])
plot1.savefig('1storderall.jpg')

# build 2nd order fit to build data
p21 = np.polyfit(oxalldata,Poxalldata,2)
p2 = np.poly1d(p21)
N = 101
x = np.linspace(0,2,N)
Pox2alldata = p2(oxalldata)
p2vals = p2(x)

# plot out functions
plot1 = plt.figure(2)
plt.ylabel('Pox')
plt.xlabel('x')
plt.title('Comparison between experimental data points and 2nd order fit')
plt.plot(oxalldata,Poxalldata,marker='o',c='r')
plt.plot(x,p2vals)
plt.xlim([0,2])
plt.ylim([1,4])
plt.legend(['experimental data','2nd order fit'])
plot1.savefig('2ndorderall.jpg')

# build 3rd order fit to build data
p31 = np.polyfit(oxalldata,Poxalldata,3)
p3 = np.poly1d(p31)
N = 101
x = np.linspace(0,2,N)
Pox3alldata = p3(oxalldata)
p3vals = p3(x)

# plot out functions
plot1 = plt.figure(3)
plt.ylabel('Pox')
plt.xlabel('x')
plt.title('Comparison between experimental data points and 3rd order fit')
plt.plot(oxalldata,Poxalldata,marker='o',c='r')
plt.plot(x,p3vals)
plt.xlim([0,2])
plt.ylim([1,4])
plt.legend(['experimental data','3rd order fit'])
plot1.savefig('3rdorderall.jpg')

# build 4th order fit to build data
p41 = np.polyfit(oxalldata,Poxalldata,4)
p4 = np.poly1d(p41)
N = 101
x = np.linspace(0,2,N)
Pox4alldata = p4(oxalldata)
p4vals = p4(x)

# plot out functions
plot1 = plt.figure(4)
plt.ylabel('Pox')
plt.xlabel('x')
plt.title('Comparison between experimental data points and 4th order fit')
plt.plot(oxalldata,Poxalldata,marker='o',c='r')
plt.plot(x,p4vals)
plt.xlim([0,2])
plt.ylim([1,4])
plt.legend(['experimental data','4th order fit'])
plot1.savefig('4thorderall.jpg')

# build 5th order fit to build data
p51 = np.polyfit(oxalldata,Poxalldata,5)
p5 = np.poly1d(p51)
N = 101
x = np.linspace(0,2,N)
Pox5alldata = p5(oxalldata)
p5vals = p5(x)

# plot out functions
plot1 = plt.figure(5)
plt.ylabel('Pox')
plt.xlabel('x')
plt.title('Comparison between experimental data points and 5th order fit')
plt.plot(oxalldata,Poxalldata,marker='o',c='r')
plt.plot(x,p5vals)
plt.xlim([0,2])
plt.ylim([1,4])
plt.legend(['experimental data','5th order fit'])
plot1.savefig('5thorderall.jpg')

# build 6th order fit to build data
p61 = np.polyfit(oxalldata,Poxalldata,6)
p6 = np.poly1d(p61)
N = 101
x = np.linspace(0,2,N)
Pox6alldata = p6(oxalldata)
p6vals = p6(x)

# plot out functions
plot1 = plt.figure(6)
plt.ylabel('Pox')
plt.xlabel('x')
plt.title('Comparison between experimental data points and 6th order fit')
plt.plot(oxalldata,Poxalldata,marker='o',c='r')
plt.plot(x,p6vals)
plt.xlim([0,2])
plt.ylim([1,4])
plt.legend(['experimental data','6th order fit'])
plot1.savefig('6thorderall.jpg')

# Calculate RMSEs for each polynomial fit
n = len(oxalldata)
RMSE_array = np.linspace(0,1,6)
for i in range(n):

    # build 1st order fit to build data
    RMSE_array[0] = RMSE_array[0] + (p1(oxalldata[i])-Poxalldata[i])**2

    # build 2nd order fit to build data
    RMSE_array[1] = RMSE_array[1] + (p2(oxalldata[i])-Poxalldata[i])**2

    # build 3rd order fit to build data
    RMSE_array[2] = RMSE_array[2] + (p3(oxalldata[i])-Poxalldata[i])**2

    # build 4th order fit to build data
    RMSE_array[3] = RMSE_array[3] + (p4(oxalldata[i])-Poxalldata[i])**2

    # build 5th order fit to build data
    RMSE_array[4] = RMSE_array[4] + (p5(oxalldata[i])-Poxalldata[i])**2

    # build 6th order fit to build data
    RMSE_array[5] = RMSE_array[5] + (p6(oxalldata[i])-Poxalldata[i])**2

RMSE_array = np.sqrt(RMSE_array/n)
xarr = np.arange(6)+1
RMSE_min = np.min(RMSE_array)
xarr_min = np.argmin(RMSE_array) + 1
optlabel=('Minimum RMSE={0:4.2f} for order of fit={1:2d}'.format(RMSE_min,xarr_min))

# plot out RMSE data
plot1 = plt.figure(7)
plt.ylabel('RMSE')
plt.xlabel('order of fit')
plt.title('RMSE from polytnomial curve fitting with all data vs of order of fit')
plt.text(2.5,0.4,optlabel)
plt.plot(xarr,RMSE_array)
plt.xlim([1,6])
plot1.savefig('RMSE_alldata.jpg')
