"""
Solution of equations from workshop problem 17
Analysis results in 3x3 matrix equation for unknonws (x1, x1, lambda)
8x1 -5x2 + lambda = 8
-5x1 + 6x2 + lambda = 0
x1 + x2 = 4
"""
import numpy as np

A = np.array([[8,-5,1],[-5,6,1],[1,1,0]])
rhs = np.array([8,0,4])
x = np.linalg.solve(A,rhs)
print('Solution of workshop problem 17:')
print('x1={0:6.3f} x2={1:6.3f} lambda={2:6.3f}\n'.format(x[0],x[1],x[2]))

"""
Solution of equations from workshop problem 18 results in 5x5 matrix
equation for unknowns (x1,x2,x3,lambda1,lambda2)
2x1 + 2lambda1 + lambda2 = 2
2x2 + 3lambda1 + lambda2 = -4
2x3 + 2lambda2 = 4
2x1 + 3x2 = 1
x1 + x2 + 2x3 = 4
"""
A = np.array([[2,0,0,2,1],[0,2,0,3,1],[0,0,2,0,2],[2,3,0,0,0],[1,1,2,0,0]])
rhs = np.array([2,-4,4,1,4])
x = np.linalg.solve(A,rhs)
print('Solution of workshop problem 18:')
print('x1={0:6.3f} x2={1:6.3f} x3={2:6.3f} lambda1={3:6.3f} lambda2={4:6.3f}\n'.format(x[0],x[1],x[2],x[3],x[4]))

"""
Solution of equations from workshop problem 19 results in 3x3
nonlinear system of equations for unknowns (x1,x2,lambda)
18x1 + 18x2 + 2x1lambda + 2lambda = 0
18x1 + 26x2 + 2x2lambda = 0
x1^2 + x2^2 + 2x1 -16  = 0
"""
from scipy.optimize import fsolve
x0 = [0, 0, 0]
def problem19func(x):
    return [18*x[0] + 18*x[1] + 2*x[0]*x[2] + 2*x[2],18*x[0] + 26*x[1] + 2*x[1]*x[2], x[0]**2 + x[1]**2 + 2*x[0] - 16]
root = fsolve(problem19func,x0)
print('Solution of workshop problem 19:')
print('x1={0:6.3f} x2={1:6.3f} lambda={2:6.3f}\n'.format(root[0],root[1],root[2]))

"""
Solution of KKT equations from workshop problem 22.
The optimal solution of the KKT equatiosn for example 22 is the case 
s1 = s2 = 0, which leads to the 4 nonlinear equations for the 4 unknowns
(x1,x2,mu1,mu2):
x2 + mu1 + 2x1mu2 = 0
x1 + 2x2mu1 + 2x2mu2 = 0
x1 + x2^2 = 0
x1^2 + x2^2 - 9 = 0
"""
x0 = [-1, 1, 0, 0]
def problem22func(x):
    return [x[1] + x[2] + 2*x[0]*x[3],x[0] + 2*x[1]*x[2] + 2*x[1]*x[3], x[0] + x[1]**2,x[0]**2+x[1]**2-9]
root = fsolve(problem22func,x0)
print('Solution of workshop problem 22:')
print('x1={0:6.3f} x2={1:6.3f} mu1={2:6.3f} mu2={3:6.3f}\n'.format(root[0],root[1],root[2],root[3]))

print('Finished\n')