"""
Graphical Solution of Workshop Problem 15 
"""
import numpy as np
import matplotlib.pyplot as plt

###############################################################################
# define functions
###############################################################################
# create_contours for specified value of S in graphical problem 15
###############################################################################
def create_contour(fval,x1,N):
    
    x2fplus = np.linspace(0,1,N+1); x2fminus = np.linspace(0,1,N+1);
    
    # create array of defines values for the specified value of f=fval
    undefined = 1e10 + 1; pi = np.pi;
    
    for i in range(0,N+1):
        discrim = pi*pi*x1[i]*x1[i] + 2*pi*fval
        if (discrim < 0):
            x2fplus[i] = undefined
            x2fminus[i] = undefined
        else:
            x2fplus[i] = (-pi*x1[i] + np.sqrt(discrim))/pi
            x2fminus[i] = (-pi*x1[i] - np.sqrt(discrim))/pi
            
    # create arrays of defined values
    ndefined = 0
    x1f_defined = np.linspace(0,1,N+1)
    x2fplus_defined = np.linspace(0,1,N+1); x2fminus_defined = np.linspace(0,1,N+1);    
    for i in range(0,N+1):
        if (x2fplus[i] < (undefined-1)):
            ndefined = ndefined + 1
            x1f_defined[ndefined-1] = x1[i]
            x2fplus_defined[ndefined-1] = x2fplus[i]
            x2fminus_defined[ndefined-1] = x2fminus[i]
            
    # create arrays of defined values for plotting    
    if (ndefined != 0):
        x1f_plot = np.linspace(0,1,ndefined)
        x2fplus_plot = np.linspace(0,1,ndefined)
        x2fminus_plot = np.linspace(0,1,ndefined)
        for i in range(0,ndefined):
            x1f_plot[i] = x1f_defined[i]
            x2fplus_plot[i] = x2fplus_defined[i]
            x2fminus_plot[i] = x2fminus_defined[i]
                
    return ndefined,x1f_plot,x2fplus_plot,x2fminus_plot
###############################################################################

# Problem 15 Graphical solution
H_min = 8; H_max=18; N=1000;
D_min = 3.5; D_max = 8;
H=np.linspace(H_min,H_max,N+1)
Dg1=np.linspace(0,1,N+1)
for i in range(0,N+1):
    Dg1[i] = 40/(np.sqrt(np.pi*H[i]))
    
# Plot out contour values
plt.ion()
fig=plt.figure()
plt.plot(H,Dg1,'b-',linewidth=1,markersize=1,label='D=40/$\sqrt{\pi H}$')     

# Plot results for various values of S: (i) S = 300.0
Sval = 300.0
ndefined,Hf_plot,Dfplus_plot,Dfminus_plot = create_contour(Sval,H,N)
plt.plot(Hf_plot,Dfplus_plot,'r--',linewidth=0.5,markersize=1,label='Df+ (f=300)')     

# (ii) S = 350.0
Sval = 350.0
ndefined,Hf_plot,Dfplus_plot,Dfminus_plot = create_contour(Sval,H,N)
plt.plot(Hf_plot,Dfplus_plot,'k--',linewidth=0.5,markersize=1,label='Df+ (f=350)')     

# (ii) S = 400.0
Sval = 400.0
ndefined,Hf_plot,Dfplus_plot,Dfminus_plot = create_contour(Sval,H,N)
plt.plot(Hf_plot,Dfplus_plot,'g--',linewidth=0.5,markersize=1,label='Df+ (f=400)')     

plt.legend(loc='best')
plt.xlabel('H',style='italic')
plt.ylabel('D',style='italic')
plt.xlim(H_min, H_max)
plt.ylim(D_min, D_max)
