"""
Graphical Solution of Workshop Problem 16
Maxmimise d, b with conditions
          b >= (5.0909 x 10^{6})/d^2+ (b(g1))
          b >= 36000/50d  (b(g2))
          b >= d/2  (b(g3))
"""
import numpy as np
import matplotlib.pyplot as plt

# Problem 16 Graphical solution
d_min = 100; d_max=400; N=100;
b_min = 0.1; b_max = 500;
d=np.linspace(d_min,d_max,N+1)
bg1 = np.linspace(0,1,N+1)
bg2 = np.linspace(0,1,N+1)
bg3 = np.linspace(0,1,N+1)

# set constraints
for i in range(0,N+1):
    bg1[i] = 5.0909e6/(d[i]*d[i])
    bg2[i] = 3600/(5*d[i])
    bg3[i] = 0.5*d[i]

# Create contours of function A
A=20000.0
bf20000=np.linspace(0,1,N+1)
for i in range(0,N+1):
    bf20000[i] = A/(d[i])
    
A=23600.0
bf23600=np.linspace(0,1,N+1)
for i in range(0,N+1):
    bf23600[i] = A/(d[i])

A=30000.0
bf30000=np.linspace(0,1,N+1)
for i in range(0,N+1):
    bf30000[i] = A/(d[i])

# plot out contour values
plt.ion()
fig=plt.figure()
plt.plot(d,bg1,'b-',linewidth=1,markersize=1,label='b=5090900/$d^2$')     
plt.plot(d,bg2,'r-',linewidth=1,markersize=1,label='b=3600/5d')     
plt.plot(d,bg3,'m-',linewidth=1,markersize=1,label='b=d/2')     
plt.plot(d,bf20000,'b--',linewidth=0.25,markersize=1,label='f=100')     
plt.plot(d,bf23600,'r--',linewidth=0.25,markersize=1,label='f=200')     
plt.plot(d,bf30000,'k--',linewidth=0.25,markersize=1,label='f=300') 
plt.legend(loc='best')
plt.xlabel('x1',style='italic')
plt.ylabel('x2',style='italic')
plt.title("Workshop problem 16: contours of functions with constraints")
plt.xlim(d_min, d_max)
plt.ylim(b_min, b_max)
