# program to solve q4 from 22-23 
import numpy as np
import matplotlib.pyplot as plt

print('Reading all metamodel data\n')
builddata = open('build.txt','r').readlines()
xalldata = []
Poalldata = []
for line in builddata:
    xalldata.append(float(line.split()[0]))
    Poalldata.append(float(line.split()[1]))

print ('data read finished')

# loop over all data points for LOO validation
N = 101
x = np.linspace(0,2,N)
n = len(xalldata)
RMSE_array = np.linspace(0,1,6)
for i in range(n):
    xtrain = []
    Potrain = []
    for j in range(n):
        if (j != i):
            xtrain.append(xalldata[j])
            Potrain.append(Poalldata[j])

    # build 1st order fit to build data
    p11 = np.polyfit(xtrain,Potrain,1)
    p1 = np.poly1d(p11)
    RMSE_array[0] = RMSE_array[0] + (p1(xalldata[i])-Poalldata[i])**2

    # build 2nd order fit to build data
    p21 = np.polyfit(xtrain,Potrain,2)
    p2 = np.poly1d(p21)
    RMSE_array[1] = RMSE_array[1] + (p2(xalldata[i])-Poalldata[i])**2

    # build 3rd order fit to build data
    p31 = np.polyfit(xtrain,Potrain,3)
    p3 = np.poly1d(p31)
    RMSE_array[2] = RMSE_array[2] + (p3(xalldata[i])-Poalldata[i])**2

    # build 4th order fit to build data
    p41 = np.polyfit(xtrain,Potrain,4)
    p4 = np.poly1d(p41)
    RMSE_array[3] = RMSE_array[3] + (p4(xalldata[i])-Poalldata[i])**2

    # build 5th order fit to build data
    p51 = np.polyfit(xtrain,Potrain,5)
    p5 = np.poly1d(p51)
    RMSE_array[4] = RMSE_array[4] + (p5(xalldata[i])-Poalldata[i])**2

    # build 6th order fit to build data
    p61 = np.polyfit(xtrain,Potrain,6)
    p6 = np.poly1d(p61)
    RMSE_array[5] = RMSE_array[5] + (p6(xalldata[i])-Poalldata[i])**2

RMSE_array = np.sqrt(RMSE_array/n)
xarr = np.arange(6)+1
RMSE_min = np.min(RMSE_array)
xarr_min = np.argmin(RMSE_array) + 1
optlabel=('Minimum RMSE={0:4.2f} for order of fit={1:2d}'.format(RMSE_min,xarr_min))

# plot out LOO data
plot1 = plt.figure(1)
plt.ylabel('RMSE')
plt.xlabel('order of fit')
plt.title('RMSE from Leave-One-Out validation vs of order of fit')
plt.text(2,8,optlabel)
plt.plot(xarr,RMSE_array)
plt.xlim([1,6])
plot1.savefig('RMSE_loo.jpg')
