# practical2_task4.py
import numpy as np
from scipy.integrate import odeint

# time derivative for linearised analysis - note need argument to use odeint
def f(u,t,A):
    return np.matmul(A,u)
    
# initialise parameters
alpha=0.005
beta=0.01
zeta=0.02
N=200
t_end=1.0
t_axis = np.linspace(0, t_end, N+1)
dt=t_end/N
H_0=4000
H=H_0
Z_0=2
R_0=0
u0 = [H_0,Z_0,R_0]

# define the linearised matrix A
A = np.array([[0,-beta*H,0], [0,beta*H-alpha*H,zeta], [0,alpha*H,-zeta]])

# Implicit euler solution
M = np.identity(3) - dt*A
u_imp = np.zeros([N+1,3])
u_imp[0,:] = u0
for i in range(N):
    u_imp[i+1,:] = np.linalg.solve(M,u_imp[i,:])

# solve with odeint
u_odeint = odeint(f,u0,t_axis,args=(A,))

# plotting
import matplotlib.pyplot as plt
plot1 = plt.figure(1)
plt.plot(t_axis,u_imp[:,0],'r') 
plt.plot(t_axis,u_imp[:,1],'r--') 
plt.plot(t_axis,u_odeint[:,0],'k') 
plt.plot(t_axis,u_odeint[:,1],'k--') 
plt.xlim([0,1])
plt.ylim([-1000,5000])
plt.xlabel('Time')
plt.ylabel('Number')
plt.legend(['Humans (Imp)','Zombies (Imp)','Humans(odeint)','Zombies(odeint)'])
plt.title('A first plot')