"""
Graphical Solution of Workshop Problem 1 
"""
import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import linprog

###############################################################################
# define functions
###############################################################################
# create_contour
###############################################################################
def create_contour(fval,x1,N):
    
    x2fplus = np.linspace(0,1,N+1); x2fminus = np.linspace(0,1,N+1);
    
    # create array of defines values for the specified value of f=fval
    undefined = 1e10 + 1
    
    for i in range(0,N+1):
        discrim = fval - (x1[i]-3)**2
        if (discrim < 0):
            x2fplus[i] = undefined
            x2fminus[i] = undefined
        else:
            x2fplus[i] = 3 + np.sqrt(discrim)
            x2fminus[i] = 3 - np.sqrt(discrim)
            
    # create arrays of defined values
    ndefined = 0
    x1f_defined = np.linspace(0,1,N+1)
    x2fplus_defined = np.linspace(0,1,N+1); x2fminus_defined = np.linspace(0,1,N+1);    
    for i in range(0,N+1):
        if (x2fplus[i] < (undefined-1)):
            ndefined = ndefined + 1
            x1f_defined[ndefined-1] = x1[i]
            x2fplus_defined[ndefined-1] = x2fplus[i]
            x2fminus_defined[ndefined-1] = x2fminus[i]
            
    # create arrays of defined values for plotting    
    if (ndefined != 0):
        x1f_plot = np.linspace(0,1,ndefined)
        x2fplus_plot = np.linspace(0,1,ndefined)
        x2fminus_plot = np.linspace(0,1,ndefined)
        for i in range(0,ndefined):
            x1f_plot[i] = x1f_defined[i]
            x2fplus_plot[i] = x2fplus_defined[i]
            x2fminus_plot[i] = x2fminus_defined[i]
                
    return ndefined,x1f_plot,x2fplus_plot,x2fminus_plot
###############################################################################

# Problem 1 Graphical solution
x1_min = 0; x1_max=6; N=1000;
x2_min = 0; x2_max = 6;
x1=np.linspace(x1_min,x1_max,N+1)
x2g1 = 4 - x1

plt.ion()
fig=plt.figure()
plt.plot(x1,x2g1,'k-',linewidth=1,markersize=1,label='x1+x2=4')     

# Plot results for f = 2.0
fval = 2.0
ndefined,x1f_plot,x2fplus_plot,x2fminus_plot = create_contour(fval,x1,N)
plt.plot(x1f_plot,x2fplus_plot,'b-',linewidth=0.5,markersize=1,label='x2f+(f=2)')     
plt.plot(x1f_plot,x2fminus_plot,'g-',linewidth=0.5,markersize=1,label='x2f-(f=2)') 

fval = 4.0
ndefined,x1f_plot,x2fplus_plot,x2fminus_plot = create_contour(fval,x1,N)
plt.plot(x1f_plot,x2fplus_plot,'r-',linewidth=0.5,markersize=1,label='x2f+(f=4)')     
plt.plot(x1f_plot,x2fminus_plot,'y-',linewidth=0.5,markersize=1,label='x2f-(f=4)')

fval = 6.0
ndefined,x1f_plot,x2fplus_plot,x2fminus_plot = create_contour(fval,x1,N)
plt.plot(x1f_plot,x2fplus_plot,'m-',linewidth=0.5,markersize=1,label='x2f+(f=6)')     
plt.plot(x1f_plot,x2fminus_plot,'c-',linewidth=0.5,markersize=1,label='x2f-(f=6)')

plt.legend(loc='best')
plt.xlabel('x1',style='italic')
plt.ylabel('x2',style='italic')
plt.xlim(x1_min, x1_max)
plt.ylim(x2_min, x2_max)
