"""
Graphical Solution of Workshop Problem 4
Maxmimise 4x1x2 with conditions
          x1 + x2 <= 20
          x2 - x1 <= 10 
"""
import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import linprog

# Problem 4 Graphical solution
x1_min = 0.1; x1_max=20; N=100;
x2_min = 0.1; x2_max = 30;
x1=np.linspace(x1_min,x1_max,N+1)
x2g1 = 20 - x1
x2g2 = 10 + x1

# Create contours of f
f=100.0
x2f100=np.linspace(x1_min,x1_max,N+1)
for i in range(0,N+1):
    x2f100[i] = f/(4*x1[i])

f=200.0
x2f200=np.linspace(x1_min,x1_max,N+1)
for i in range(0,N+1):
    x2f200[i] = f/(4*x1[i])

f=300.0
x2f300=np.linspace(x1_min,x1_max,N+1)
for i in range(0,N+1):
    x2f300[i] = f/(4*x1[i])

f=400.0
x2f400=np.linspace(x1_min,x1_max,N+1)
for i in range(0,N+1):
    x2f400[i] = f/(4*x1[i])

# plot out contour values
plt.ion()
fig=plt.figure()
plt.plot(x1,x2g1,'b-',linewidth=1,markersize=1,label='x1+x2=20')     
plt.plot(x1,x2g2,'r-',linewidth=1,markersize=1,label='x2-x1=10')     
plt.plot(x1,x2f100,'b--',linewidth=0.25,markersize=1,label='f=100')     
plt.plot(x1,x2f200,'r--',linewidth=0.25,markersize=1,label='f=200')     
plt.plot(x1,x2f300,'k--',linewidth=0.25,markersize=1,label='f=300') 
plt.plot(x1,x2f400,'g--',linewidth=0.25,markersize=1,label='f=400')     
plt.legend(loc='best')
plt.xlabel('x1',style='italic')
plt.ylabel('x2',style='italic')
plt.title("Workshop problem 4: contours of functions with constraints")
plt.xlim(x1_min, x1_max)
plt.ylim(x2_min, x2_max)
